/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;

public abstract class Flash040Core {
    private Logger FLASH_DEBUG = Logger.getLogger(Flash040Core.class.getName());
    private static final int FLASH040_ERASE_MASK_SIZE = 8;
    private static int ERASE_SECTOR_TIMEOUT_CYCLES = 50;
    private static int ERASE_SECTOR_CYCLES = 1012;
    private static int ERASE_CHIP_CYCLES = 8192;
    protected static FlashTypes[] FlashTypes = new FlashTypes[]{new FlashTypes(1, -92, 524288, 458752, 65536, 16, 21845, 10922, Short.MAX_VALUE, Short.MAX_VALUE, 64), new FlashTypes(1, -92, 524288, 458752, 65536, 16, 1365, 682, 2047, 2047, 64), new FlashTypes(1, 32, 131072, 114688, 16384, 14, 21845, 10922, Short.MAX_VALUE, Short.MAX_VALUE, 64), new FlashTypes(1, 65, 0x400000, 0x3F0000, 65536, 16, 1366, 681, 2047, 2047, 68)};

    private boolean flashMagic1(Flash040Context flash040Context, int addr) {
        return (addr & Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].magic1Mask) == Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].magic1Addr;
    }

    private boolean flashMagic2(Flash040Context flash040Context, int addr) {
        return (addr & Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].magic2Mask) == Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].magic2Addr;
    }

    private void flashClearEraseMask(Flash040Context flash040Context) {
        for (int i = 0; i < 8; ++i) {
            flash040Context.eraseMask[i] = 0;
        }
    }

    private int flashSectorToAddr(Flash040Context flash040Context, int sector) {
        int sectorSize = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].sectorSize;
        return sector * sectorSize;
    }

    private int flashAddrToSectorNumber(Flash040Context flash040Context, int addr) {
        int sectorAddr = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].sectorMask & addr;
        int sectorShift = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].sectorShift;
        return sectorAddr >> sectorShift;
    }

    private void flashAddSectorToEraseMask(Flash040Context flash040Context, int addr) {
        int sectorNum = this.flashAddrToSectorNumber(flash040Context, addr);
        int n = sectorNum >> 3;
        flash040Context.eraseMask[n] = (byte)(flash040Context.eraseMask[n] | (byte)(1 << (sectorNum & 7)));
    }

    private void flashEraseSector(Flash040Context flash040Context, int sector) {
        int sectorSize = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].sectorSize;
        int sectorAddr = this.flashSectorToAddr(flash040Context, sector);
        this.FLASH_DEBUG.fine(String.format("Erasing 0x%x - 0x%x", sectorAddr, sectorAddr + sectorSize - 1));
        Arrays.fill(flash040Context.flashData, sectorAddr, sectorSize, (byte)-1);
        flash040Context.flashDirty = 1;
    }

    private void flashEraseChip(Flash040Context flash040Context) {
        this.FLASH_DEBUG.fine("Erasing chip");
        Arrays.fill(flash040Context.flashData, 0, Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].size, (byte)-1);
        flash040Context.flashDirty = 1;
    }

    private boolean flashProgramByte(Flash040Context flash040Context, int addr, byte byt) {
        byte oldData = flash040Context.flashData[addr];
        byte newData = (byte)(oldData & byt);
        this.FLASH_DEBUG.fine(String.format("Programming 0x%05x with 0x%02x (%02x->%02x)", addr, byt, oldData, oldData & byt));
        flash040Context.programByte = byt;
        flash040Context.flashData[addr] = newData;
        flash040Context.flashDirty = 1;
        return newData == byt;
    }

    private byte flashWriteOperationStatus(Flash040Context flash040Context) {
        return (byte)((long)((flash040Context.programByte ^ 0x80) & 0x80) | (this.maincpuClk() & 2L) << 5 | 0x20L);
    }

    private byte flashEraseOperationStatus(Flash040Context flash040Context) {
        byte v = flash040Context.programByte;
        flash040Context.programByte = (byte)(flash040Context.programByte ^ Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].statusToggleBits);
        if (flash040Context.flashState != Flash040State.FLASH040_STATE_SECTOR_ERASE_TIMEOUT) {
            v = (byte)(v | 8);
        }
        return v;
    }

    protected void eraseAlarmHandler(Flash040Context flash040Context) {
        this.alarmUnset(flash040Context.eraseAlarm);
        this.FLASH_DEBUG.fine(String.format("Erase alarm, state %s", new Object[]{flash040Context.flashState}));
        switch (flash040Context.flashState.ordinal()) {
            case 10: 
            case 11: {
                for (int i = 0; i < 64; ++i) {
                    int j = i >> 3;
                    byte m = (byte)(1 << (i & 7));
                    if ((flash040Context.eraseMask[j] & m) == 0) continue;
                    this.flashEraseSector(flash040Context, i);
                    int n = j;
                    flash040Context.eraseMask[n] = (byte)(flash040Context.eraseMask[n] & (byte)(~m));
                    break;
                }
                byte m = 0;
                for (int i = 0; i < 8; ++i) {
                    m = (byte)(m | flash040Context.eraseMask[i]);
                }
                if (m != 0) {
                    this.alarmSet(flash040Context.eraseAlarm, this.maincpuClk() + (long)ERASE_SECTOR_CYCLES);
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 9: {
                this.flashEraseChip(flash040Context);
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            default: {
                this.FLASH_DEBUG.fine(String.format("Erase alarm - error, state %s unhandled!", new Object[]{flash040Context.flashState}));
            }
        }
    }

    public void flash040CoreStore(Flash040Context flash040Context, int addr, byte byt) {
        Flash040State oldState = flash040Context.flashState;
        Flash040State oldBaseState = flash040Context.flashBaseState;
        block0 : switch (flash040Context.flashState.ordinal()) {
            case 0: {
                if (!this.flashMagic1(flash040Context, addr) || byt != -86) break;
                flash040Context.flashState = Flash040State.FLASH040_STATE_MAGIC_1;
                break;
            }
            case 1: {
                if (this.flashMagic2(flash040Context, addr) && byt == 85) {
                    flash040Context.flashState = Flash040State.FLASH040_STATE_MAGIC_2;
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 2: {
                if (this.flashMagic1(flash040Context, addr)) {
                    switch (byt & 0xFF) {
                        case 144: {
                            flash040Context.flashState = Flash040State.FLASH040_STATE_AUTOSELECT;
                            flash040Context.flashBaseState = Flash040State.FLASH040_STATE_AUTOSELECT;
                            break block0;
                        }
                        case 240: {
                            flash040Context.flashState = Flash040State.FLASH040_STATE_READ;
                            flash040Context.flashBaseState = Flash040State.FLASH040_STATE_READ;
                            break block0;
                        }
                        case 160: {
                            flash040Context.flashState = Flash040State.FLASH040_STATE_BYTE_PROGRAM;
                            break block0;
                        }
                        case 128: {
                            flash040Context.flashState = Flash040State.FLASH040_STATE_ERASE_MAGIC_1;
                            break block0;
                        }
                    }
                    flash040Context.flashState = flash040Context.flashBaseState;
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 4: {
                if (this.flashProgramByte(flash040Context, addr, byt)) {
                    flash040Context.flashState = flash040Context.flashBaseState;
                    break;
                }
                flash040Context.flashState = Flash040State.FLASH040_STATE_BYTE_PROGRAM_ERROR;
                break;
            }
            case 6: {
                if (this.flashMagic1(flash040Context, addr) && byt == -86) {
                    flash040Context.flashState = Flash040State.FLASH040_STATE_ERASE_MAGIC_2;
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 7: {
                if (this.flashMagic2(flash040Context, addr) && byt == 85) {
                    flash040Context.flashState = Flash040State.FLASH040_STATE_ERASE_SELECT;
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 8: {
                if (this.flashMagic1(flash040Context, addr) && byt == 16) {
                    flash040Context.flashState = Flash040State.FLASH040_STATE_CHIP_ERASE;
                    flash040Context.programByte = 0;
                    this.alarmSet(flash040Context.eraseAlarm, this.maincpuClk() + (long)ERASE_CHIP_CYCLES);
                    break;
                }
                if (byt == 48) {
                    this.flashAddSectorToEraseMask(flash040Context, addr);
                    flash040Context.programByte = 0;
                    flash040Context.flashState = Flash040State.FLASH040_STATE_SECTOR_ERASE_TIMEOUT;
                    this.alarmSet(flash040Context.eraseAlarm, this.maincpuClk() + (long)ERASE_SECTOR_TIMEOUT_CYCLES);
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                break;
            }
            case 11: {
                if (byt == 48) {
                    this.flashAddSectorToEraseMask(flash040Context, addr);
                    break;
                }
                flash040Context.flashState = flash040Context.flashBaseState;
                this.flashClearEraseMask(flash040Context);
                this.alarmUnset(flash040Context.eraseAlarm);
                break;
            }
            case 10: {
                if (byt != -80) break;
                flash040Context.flashState = Flash040State.FLASH040_STATE_SECTOR_ERASE_SUSPEND;
                this.alarmUnset(flash040Context.eraseAlarm);
                break;
            }
            case 12: {
                if (byt != 48) break;
                flash040Context.flashState = Flash040State.FLASH040_STATE_SECTOR_ERASE;
                this.alarmSet(flash040Context.eraseAlarm, this.maincpuClk() + (long)ERASE_SECTOR_CYCLES);
                break;
            }
            case 3: 
            case 5: {
                if (this.flashMagic1(flash040Context, addr) && byt == -86) {
                    flash040Context.flashState = Flash040State.FLASH040_STATE_MAGIC_1;
                }
                if (byt != -16) break;
                flash040Context.flashState = Flash040State.FLASH040_STATE_READ;
                flash040Context.flashBaseState = Flash040State.FLASH040_STATE_READ;
                break;
            }
        }
        this.FLASH_DEBUG.fine(String.format("Write %02x to %05x, state %s->%s (base state %s->%s)", new Object[]{byt, addr, oldState, flash040Context.flashState, oldBaseState, flash040Context.flashBaseState}));
    }

    public byte flash040CoreRead(Flash040Context flash040Context, int addr) {
        byte value;
        Flash040State oldState = flash040Context.flashState;
        block0 : switch (flash040Context.flashState.ordinal()) {
            case 3: {
                if (flash040Context.flashType == Flash040Type.FLASH040_TYPE_032B_A0_1_SWAP && (addr & 0xFF) < 4) {
                    addr = "\u0000\u0002\u0001\u0003".charAt(addr & 3);
                }
                switch (addr & 0xFF) {
                    case 0: {
                        value = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].manufacturerID;
                        break block0;
                    }
                    case 1: {
                        value = Flash040Core.FlashTypes[flash040Context.flashType.ordinal()].deviceID;
                        break block0;
                    }
                    case 2: {
                        value = 0;
                        break block0;
                    }
                }
                value = flash040Context.flashData[addr];
                break;
            }
            case 5: {
                value = this.flashWriteOperationStatus(flash040Context);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                value = this.flashEraseOperationStatus(flash040Context);
                break;
            }
            default: {
                value = flash040Context.flashData[addr];
            }
        }
        if (this.FLASH_DEBUG.isLoggable(Level.FINE) && oldState != Flash040State.FLASH040_STATE_READ) {
            this.FLASH_DEBUG.fine(String.format("Read %02x from %05x, state %s.%s", new Object[]{value, addr, oldState, flash040Context.flashState}));
        }
        flash040Context.lastRead = value;
        return value;
    }

    public byte flash040CorePeek(Flash040Context flash040Context, int addr) {
        return flash040Context.flashData[addr];
    }

    public void flash040CoreReset(Flash040Context flash040Context) {
        this.FLASH_DEBUG.fine("Reset");
        flash040Context.flashState = Flash040State.FLASH040_STATE_READ;
        flash040Context.flashBaseState = Flash040State.FLASH040_STATE_READ;
        flash040Context.programByte = 0;
        this.flashClearEraseMask(flash040Context);
        this.alarmUnset(flash040Context.eraseAlarm);
    }

    public void flash040coreInit(Flash040Context flash040Context, EventScheduler alarmContext, Flash040Type type, byte[] data) {
        this.FLASH_DEBUG.fine("Init");
        flash040Context.flashData = data;
        flash040Context.flashType = type;
        flash040Context.flashState = Flash040State.FLASH040_STATE_READ;
        flash040Context.flashBaseState = Flash040State.FLASH040_STATE_READ;
        flash040Context.programByte = 0;
        this.flashClearEraseMask(flash040Context);
        flash040Context.flashDirty = 0;
        flash040Context.eraseAlarm = Event.of("Flash040Alarm", event -> this.eraseAlarmHandler(flash040Context));
    }

    public void flash040CoreShutdown(Flash040Context flash040Context) {
        this.FLASH_DEBUG.fine("Shutdown");
    }

    protected abstract long maincpuClk();

    protected abstract void alarmUnset(Event var1);

    protected abstract void alarmSet(Event var1, long var2);

    protected static class FlashTypes {
        protected byte manufacturerID;
        protected byte deviceID;
        protected int size;
        protected int sectorMask;
        protected int sectorSize;
        protected int sectorShift;
        protected int magic1Addr;
        protected int magic2Addr;
        protected int magic1Mask;
        protected int magic2Mask;
        protected byte statusToggleBits;

        protected FlashTypes(byte manufacturer, byte device, int sz, int secMask, int secSize, int secShift, int mag1Addr, int mag2Addr, int mag1Mask, int mag2Mask, byte status) {
            this.manufacturerID = manufacturer;
            this.deviceID = device;
            this.size = sz;
            this.sectorMask = secMask;
            this.sectorSize = secSize;
            this.sectorShift = secShift;
            this.magic1Addr = mag1Addr;
            this.magic2Addr = mag2Addr;
            this.magic1Mask = mag1Mask;
            this.magic2Mask = mag2Mask;
            this.statusToggleBits = status;
        }
    }

    public static class Flash040Context {
        public byte[] flashData;
        protected Flash040State flashState;
        protected Flash040State flashBaseState;
        protected byte programByte;
        protected byte[] eraseMask = new byte[8];
        protected int flashDirty;
        protected Flash040Type flashType;
        protected byte lastRead;
        protected Event eraseAlarm;
    }

    public static enum Flash040Type {
        FLASH040_TYPE_NORMAL,
        FLASH040_TYPE_B,
        FLASH040_TYPE_010,
        FLASH040_TYPE_032B_A0_1_SWAP,
        FLASH040_TYPE_NUM;

    }

    private static enum Flash040State {
        FLASH040_STATE_READ,
        FLASH040_STATE_MAGIC_1,
        FLASH040_STATE_MAGIC_2,
        FLASH040_STATE_AUTOSELECT,
        FLASH040_STATE_BYTE_PROGRAM,
        FLASH040_STATE_BYTE_PROGRAM_ERROR,
        FLASH040_STATE_ERASE_MAGIC_1,
        FLASH040_STATE_ERASE_MAGIC_2,
        FLASH040_STATE_ERASE_SELECT,
        FLASH040_STATE_CHIP_ERASE,
        FLASH040_STATE_SECTOR_ERASE,
        FLASH040_STATE_SECTOR_ERASE_TIMEOUT,
        FLASH040_STATE_SECTOR_ERASE_SUSPEND;

    }
}

